/**
* @(#) ViewerApplet.java   
* 
* modifications made by Aaron N. Chang, PhD 
* 11/2004
* Dept of Microbiology
* Univ of Washington, Seattle
*/

/*
 * @(#)GraphInteraction.java 
 * based on the Graph.java by Sun Microsystems, Inc.
 * modified by Ralf Mrowka, Humboldt-University-Berlin, Germany, 2000
 */

/*
 * @(#)Graph.java	1.9 98/10/28
 *
 * Copyright (c) 1997, 1998 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Sun grants you ("Licensee") a non-exclusive, royalty free, license to use,
 * modify and redistribute this software in source and binary code form,
 * provided that i) this copyright notice and license appear on all copies of
 * the software; and ii) Licensee does not utilize the software in a manner
 * which is disparaging to Sun.
 *
 * This software is provided "AS IS," without a warranty of any kind. ALL
 * EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES, INCLUDING ANY
 * IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
 * NON-INFRINGEMENT, ARE HEREBY EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE
 * LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING
 * OR DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN OR ITS
 * LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT,
 * INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER
 * CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF
 * OR INABILITY TO USE SOFTWARE, EVEN IF SUN HAS BEEN ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.
 *
 * This software is not designed or intended for use in on-line control of
 * aircraft, air traffic, aircraft navigation or aircraft communications; or in
 * the design, construction, operation or maintenance of any nuclear
 * facility. Licensee represents and warrants that it will not use or
 * redistribute the Software for such purposes.
 */

package org.compbio.bioverse.viewer;

import java.applet.AppletContext;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;

import javax.swing.JApplet;
import javax.swing.JPanel;
import javax.swing.JLabel;


public class ViewerApplet extends JApplet 
		implements ActionListener, ItemListener, MouseListener, KeyListener {  
		
	// constants/parameters - note that applet size is dependent on these
	private static final int MAXUNSORTEDGOCATS = 1000;
	private static final int MAXROWS = 1000;
	private static final int MAXVIEWABLENODES = 400;
	private static final int MAXSEARCHLENGTH = 10;
	//private boolean usingStruts = false;
			
	// inter-applet communications		  
	public static ViewerApplet selfRef = null; // for app comm in from tableapplet
	
	private Running ru;

    // table applet-related
	//private InteractionRow[] graphRows = null;
	
	// panel-related
	private ViewerPanel panel;
	private JPanel controlPanel;
	private String[] goCatArray; //unsorted GO menu categories array during readin
	private Choice GOmenu;  //function drop down menu
	private Choice neighbours_level;
	private Button refresh;
	private Button show_all;
	
	private String searchTerm = "";
	private TextField textEntry;
	private boolean substringCheck = false;
	private boolean wildCard = false;
	
	private int rowCount = 0; // for data read in
	private int catIndex = 0; // for data read in
	
	public Checkbox hide_relax;
	private Checkbox show_fu_text;
	private Checkbox chb_freeze;
	private String urlPattern = "";
	
	// data transfer objects, especially from Action classes
	ArrayList intListFromSearch;

	
    /**CONSTRUCTOR
     * 
     */
    public ViewerApplet() {
		panel = new ViewerPanel(this);
		GOmenu = new Choice();
		ru = new Running();
		hide_relax = new Checkbox();
		neighbours_level = new Choice();
		refresh = new Button("Refresh");
		show_all = new Button("Show all");
		show_fu_text = new Checkbox("Show_function");
		textEntry = new TextField(MAXSEARCHLENGTH - 4);
		chb_freeze = new Checkbox("Freeze");  // freeze checkbox
    }
    
    
    /**overload contructor to allow data to be PUSHED into the viewer from Action class
     * 
     * @param intList
     */
    public ViewerApplet(ArrayList intList) {
    	this();
    	intListFromSearch = intList;
    	//usingStruts = true;
    }
    

    /**init() method
     * 
     */
    public void init() {
    	//graphRows = new InteractionRow[MAXROWS];
    	
    	// self reference to allow public method access (data share betw applets)
		selfRef = this; 
		
		// set layout
		getContentPane().setLayout(new BorderLayout());

		// set limits on running object
        ru.count = 0;
        ru.maxcount = 3000;  
	
		// add panel and mouseListener 
		panel = new ViewerPanel(this);
		panel.addMouseListener(this);  
		getContentPane().add("Center", panel);
		
		// add menubar
		controlPanel = new JPanel();
		controlPanel.setLayout(new FlowLayout(FlowLayout.LEFT));
		getContentPane().add("North", controlPanel);
	
		// search text field
		controlPanel.add(new Label("Search", Label.RIGHT)); 
		textEntry.addKeyListener(this);
		controlPanel.add(textEntry);
				
		controlPanel.add(chb_freeze); 
		chb_freeze.addItemListener(this);
		
		// set up GO class menu
		controlPanel.add(new Label("Show", Label.RIGHT)); 
		controlPanel.add(GOmenu); 
		GOmenu.addItemListener(this);
		
		//	interaction distance choices
		neighbours_level.addItem("0");
		neighbours_level.addItem("1");
		neighbours_level.addItem("2");
		neighbours_level.addItem("3");
		neighbours_level.addItem("4");
		neighbours_level.addItem("5");
		neighbours_level.addItem("6");
		neighbours_level.addItem("7");
		neighbours_level.addItem("8");
		neighbours_level.addItem("9");
		neighbours_level.addItem("10");
		neighbours_level.addItem("11");
		neighbours_level.addItem("12");
	  	
		//default select
		neighbours_level.select(1);
		
		// add distance menu
		panel.neighbours_level_actual=1;
		controlPanel.add(new Label("Distance", Label.RIGHT));        
		controlPanel.add(neighbours_level); 
		neighbours_level.addItemListener(this);
		
		
		// refresh button
		controlPanel.add(refresh); 
		refresh.addActionListener(this);
		
				
		// temp storage of unsorted go categories with populations calc'ed
		goCatArray = new String[MAXUNSORTEDGOCATS]; 
			
		
		// *** READ IN DATA 
		// read data from html if that is the source when applet is init'ed
		
		// GET INTERACTIONS : format: <protein1-protein2#strength>
		getInteractionsFromHtml();
		
		// GET FUNCTIONKEYS : <BioverseID#affiliated GO cat> -> setup menu of GO cats
		getFunctionKeysFromHtml();
		
		// QuickSort go cats by population
		popQuickSort(0, catIndex-1);
		
		//	add sorted cats to menu, check to see if "ALL" option should be added to menu
		addSortedGoCatsToMenu();
		
		// GET FUNCTIONLIST : <proteinName#bioverseID>
		getFunctionListFromHtml();
		
		// nodes+edges info <- FIX: move this into the GO menu for each menu item
		JLabel nLabel = new JLabel("(n: " + panel.getNodeCount() + ", e: " + panel.nInteractions +")", JLabel.RIGHT);
		controlPanel.add(nLabel);
		
		// load GO cats for each protein into graphRows
		//loadGoCatsIntoGraphRows();
		
		// *** send graphRows data over to tableApplet for display
		//TableApplet.selfRef.loadTable(graphRows, rowCount); 
		
		// show default startup GO cat members (usually set 0)
		GOmenu.select(0); //default to 1st menu selection - FIX:does not affect display though when changed
		showSelectedNodes(GOmenu.getItem(0).substring(17));  // format
		
    }  


	/**for init() data read in
	 * 
	 *
	 */
	public void getInteractionsFromHtml() {
		String Interactions = getParameter("interaction"); // tokenize html string at interactions tag
		
		for (StringTokenizer t = new StringTokenizer(Interactions, ",") ; t.hasMoreTokens() ;) {
			String str = t.nextToken(); 
		   //System.out.println("\nstring1: " + str);
		  
			int k = str.indexOf('#');
			int i = str.indexOf('-');
		    
			if (i > 0) {
				int len = 105 +(int)( 50*Math.random()) ;
				int j = str.indexOf('/');
				
				if (j > 0) {
					len = Integer.valueOf(str.substring(j+1)).intValue();
					str = str.substring(0, j);
				}
				
				String to = str.substring(0,i);
				String from = str.substring(i+1, k);
				double strength = Double.parseDouble(str.substring(k+1));  //need to get this from html file - use new format
			
				rowCount++;
				
				panel.addInteraction(to, from, len, strength);  //ADD EDGE TO PANEL
			}
		}
	}

	
	/**data read in at init()
	 * 
	 *
	 */
	public void getFunctionKeysFromHtml() {
		String functionkey = getParameter("functionkey");
		
		for (StringTokenizer t = new StringTokenizer(functionkey, ",") ; t.hasMoreTokens() ; ) {
			 String str = t.nextToken();
			 int i = str.indexOf('#');
			 // int i = str.indexOf('%');  // use this delimiter for getting confidence
	
			// get user's url  pattern for nodes from html file (for right clicking)
			if (str.charAt(0) == 'u') {
				urlPattern = str.substring(i+1);
				
			} else {
				// FIX: in future, take in confidence of GO cat here (place after % delimiter)
		    	
				 if (i > 0) {			
					String bioverseID = str.substring(0,i);
					String aGOcat = str.substring(i+1);				
			     	
					// associate a GO cat with a bioverseID
					panel.addGoCat(bioverseID, aGOcat); 
				    
					// load pulldown menu with current GO cat
					String newCat = str.substring(i+1);
					
					boolean contains = false;
					
					// go thru entire menu - current state
					for (int m = 0; m < catIndex; m++) {
						String currMenuCat = goCatArray[m].substring(17); // format
						
						// if match is found, make note, update population count
						if (currMenuCat.equals(newCat)) {
							contains = true;
							int catCount = Integer.parseInt(goCatArray[m].substring(0,4).trim()); // format
							catCount++;
							String formattedCount;
							
							// format the menu item
							if (catCount >=0 && catCount < 10) {
								formattedCount = "   " + catCount; // 3 leading spaces
							} else if (catCount >= 10 && catCount < 100) {
								formattedCount = "  " + catCount;
							} else if (catCount >= 100 && catCount < 1000){
								formattedCount = " " + catCount;
							} else {
								formattedCount = "" + catCount;
							}
							
							goCatArray[m] = formattedCount + " proteins in " + newCat;
							break;
						}
					} // for
					
					// if no match, then add to menu list - (will need to sort by name or quantity)
					 if (contains == false) {
						goCatArray[catIndex] = "   1" + " protein  in " + newCat; // format
						catIndex++;
					 }
				 }
			}
		    
		}  //for		
	}

	
	/** data read in at init()
	 * 
	 *
	 */
	public void getFunctionListFromHtml() {
		String functionlist = getParameter("functionlist");
		for (StringTokenizer t = new StringTokenizer(functionlist, ",") ; t.hasMoreTokens() ; ) {
			String str = t.nextToken();
			int i = str.indexOf('#');
		   
			if (i > 0) {
				for (StringTokenizer f = new StringTokenizer(str.substring(i+1), "/") ; f.hasMoreTokens() ; ) {
					panel.addGoFlagToNode(str.substring(0,i), f.nextToken());
				}
			}
		}		
	}

	
	/** add sorted GO cats to menu bar
	 * 
	 *
	 */
	public void addSortedGoCatsToMenu() {
		int count = panel.getNodeCount();
		
		if (count < MAXVIEWABLENODES) {
			String allItem;
			
			if (count > 99 && count < 1000) {
				allItem = " " + count + " proteins in " + "ALL categories"; 
			} else if (count > 9 && count < 100) {
				allItem = "  " + count + " proteins in " + "ALL categories"; 
			} else if (count>= 0 && count< 10) {
				allItem = "   " + count + " proteins in " + "ALL categories";
			} else {
				allItem = count + " proteins in " + "ALL categories";
			}
			
			GOmenu.addItem(allItem);
		}
		
		for (int i = catIndex-1; i >= 0; i--) {
			GOmenu.add(goCatArray[i]);
		}			
	}


	/** ActionListener implementation method
	 * 
	 */
	public void actionPerformed(ActionEvent e) {
		Object src = e.getSource();
	
		if (src == show_all) {
			for (int i = 0 ; i < panel.getNodeCount(); i++) {
				panel.Nodes[i].on=true;
			}    
			return;
		}
	
		// refresh button handling
		if (src == refresh) { 
			ru.count = 00; 
			Dimension d = getSize();
	        
			for (int i = 0 ; i < panel.getNodeCount() ; i++) {
				Node n = panel.Nodes[i];
				if (!n.fixed) {
					n.x = 10 + (d.width-20)*Math.random();
					n.y = 10 + (d.height-20)*Math.random();
				}
			}
			ViewerApplet.selfRef.chb_freeze.setState(false);
			panel.freeze=false;
			panel.cycle_number=1;
			return;
		}

	}

	/** clear screen method
	 * 
	 *
	 */
	public void clearScreen() {
		for (int i = 0; i < panel.getNodeCount(); i++) {
			panel.Nodes[i].on = false;
		}	
	}
   
   
   /** destroy panel
    * 
    */
	public void destroy() {
		remove(panel);
		remove(controlPanel);
	}


    /** itemListener implementation
     * 
     */
    public void itemStateChanged(ItemEvent e) {
		Object src = e.getSource();
	
		if (src == show_fu_text) {
		   boolean on = e.getStateChange() == ItemEvent.SELECTED;
		   panel.show_fu_text = on; 
		}
	
		if (src == hide_relax) {
		   boolean on = e.getStateChange() == ItemEvent.SELECTED;
		   panel.hide_relax = on;
		   panel.cycle_number=1;
		}
	
		if (src == chb_freeze) {
		   boolean on = e.getStateChange() == ItemEvent.SELECTED;
		   panel.freeze = on; 
		}
	
		// interaction distance event handling
		if (src == neighbours_level ) {
		    String gechoiced = (String) e.getItem();
		    if(gechoiced.equals("ALL categories")){
				panel.neighbours_level_actual=panel.nInteractions;
		    }else{
				panel.neighbours_level_actual=Integer.valueOf(gechoiced).intValue();
		    }
		}
		
		// GO menu selection handling
		if (src == GOmenu) {
		   	String menuSelection = (String) e.getItem();  // chosen menu item string
		   	showSelectedNodes(menuSelection.substring(17)); // format ; take out population number
		   
			panel.cycle_number=1;
		} 
    } 
	    
    
    /** KeyListener implementation - for search field
     * 
     */
    public void keyPressed(KeyEvent e) {
	    if (e.getKeyCode() == KeyEvent.VK_ENTER) {
		    //System.out.println("enter    search term: " + searchTerm);
		    textEntry.setText(""); // clear
	    }
    }
    
    /** keyListener implement
     * 
     */
    public void keyReleased(KeyEvent e) {
	    boolean atLeastOne = false;
	    int stIndex = 0;
	    
	    if (e.getKeyCode() == KeyEvent.VK_ENTER) {  // user clicks enter
		    //System.out.println("*** " + searchTerm);
		    if (searchTerm.length() > 0) {
		      searchTerm = searchTerm.substring(0, searchTerm.length()-1); // remove CR
		      stIndex = searchTerm.length(); // end index
		    }
		      //System.out.println(">>" + searchTerm + "<>" + stIndex + "<    " + substringCheck);
		      
		    // need to clear screen and show only this searchTerm before clearing (HERE)
		    for (int i = 0; i < panel.getNodeCount(); i++) {
			    
			    if (substringCheck && panel.Nodes[i].lbl.length() > stIndex) {  // wildcard search
				    String mem = panel.Nodes[i].lbl.substring(0,stIndex);
				   // System.out.println("mem: " + mem);
				    
				    if (searchTerm.equals(mem)){
					    //System.out.println("true: " + panel.Nodes[i].lbl);
					    
					    panel.Nodes[i].on = true;
					    atLeastOne = true;
				    } else {
					    panel.Nodes[i].on = false;
				    }
				    
			    } else { // not wildcard search - perfect search
			    
				    if (searchTerm.equals(panel.Nodes[i].lbl)) {
					    panel.Nodes[i].on = true;
					    atLeastOne = true;
					    //System.out.println("true: " + panel.Nodes[i].lbl);
				    } else {
					    panel.Nodes[i].on = false;
					    //System.out.println("false: " + panel.Nodes[i].lbl);
				    }
			    }
		    } // for
		    
		    // these messages could be fixed, working for now
		    if (atLeastOne == false) {  // if search fails
		    	
			    for (int i = 0; i < 50; i++) { // arbitrary display, keep small, rather than show all
				    panel.Nodes[i].on = true;
			    } 
			    
			    if (wildCard == false) {
				    textEntry.setText("No Match"); 
			    } else {
				    textEntry.setText("Try Again");
			    }
			  
			   try {
				    Thread.sleep(500); // pause 500 ms so you can see the message
			   } catch (InterruptedException exc) {
				    System.out.println("interrupt error");
			   }
		    } 
		    
		   searchTerm = ""; // reset 
		   textEntry.setText(""); // clear
		   wildCard = false; // reset
		   substringCheck = false;
		   atLeastOne = false;
		   //System.out.println("reset");
	    }
    }
    
    /**keyListener
     * 
     */
    public void keyTyped(KeyEvent e) {	
	    if (searchTerm.length() < MAXSEARCHLENGTH) {
		    if (e.getKeyChar() != '*') {  //asterisk check - wildcard symbol
			    searchTerm += Character.toString(e.getKeyChar()); // convert char to String
			    //System.out.println(">>" + searchTerm);
		    } else {
			   // System.out.println("deal with wildcard case : " + searchTerm.length());
			    wildCard = true;
			    
			    if (searchTerm.length() > 0) {   // single asterisk turns on all members
				    substringCheck = true;
			    }
			   
		    }
	    } else { // entry exceeds limit
		    //System.out.println("too big");
		    textEntry.setText("Bad Entry");
		     try {
				    Thread.sleep(1000); // pause 100 ms so you can see the message
		     } catch (InterruptedException exc) {
				    System.out.println("interrupt error");
		     }
		     
		      textEntry.setText("Hit Return");
		      try {
				    Thread.sleep(1000); // pause 1 sec so you can see the message
		     } catch (InterruptedException exc) {
				    System.out.println("interrupt error");
		     }
		     
		    searchTerm = "";
	    }
    }
    

    /** handle right button mouse events separates for getting more detail on the protein node
     * 
     */
    public void mouseClicked(MouseEvent e) {
		int mouseButton = e.getButton();
	
	// get label of picked cell
	//show which members are ON (selected) - MUST GO THRU ENTIRE MEMBER ARRAY EACH TIME TO FIND IT
		for (int i = 0 ; i < panel.getNodeCount() ; i++) {
			//works for button 3 click (right button) links to the bioverse entry page for the selected member
			if (mouseButton == 3) {
				try {
					if (panel.Nodes[i].selected) { //if selected field is true for the member, provide link - note: url is species-dependent
						
						URL url = new URL (urlPattern + panel.Nodes[i].fu_lbl + "?esPick=1");
						//System.out.println("url: " + url.toString());
						
						AppletContext a = this.getAppletContext();
						a.showDocument(url, "bioverse");
						
					}
				} catch (MalformedURLException ex) {
					ex.printStackTrace();
				}
			}
		}
	}    
    
    
    // unimplemented mouseListener methods (can't use MouseAdapter)
    public void mouseEntered(MouseEvent e) {}
    public void mouseExited(MouseEvent e) {}	     
    public void mousePressed(MouseEvent e) {}   
    public void mouseReleased(MouseEvent e) {}
   
   
   /** for quicksorting
    * 
    * @param left
    * @param right
    * @param pivot
    * @return
    */
   public int popPartitionIt(int left, int right, int pivot) {
		int leftPtr = left-1;           // left    (after ++)
		int rightPtr = right;           // right-1 (after --)
		
		while(true) {                            // find bigger item
				while(Integer.parseInt(goCatArray[++leftPtr].substring(0,4).trim()) < pivot ) // format
				   ;  // (nop)
											 // find smaller item
				while(rightPtr > 0 && Integer.parseInt(goCatArray[--rightPtr].substring(0,4).trim()) > pivot) // format
				   ;  // (nop)
	
				if(leftPtr >= rightPtr)    // if pointers cross,
				   break;                    	 //  partition done
				else                        		 // not crossed, so
				   swap(leftPtr, rightPtr);  // swap elements
		}  // end while(true)
		swap(leftPtr, right);           // restore pivot
		return leftPtr;                	 // return pivot location
   }
   
   
   /** for quicksorting
    * 
    * @param left
    * @param right
    */
   public void popQuickSort(int left, int right) {
		if(right-left <= 0)        // if size <= 1,
			return;                // already sorted
		else                       // size is 2 or larger
		   {
			   int pivot = Integer.parseInt(goCatArray[right].substring(0,4).trim());    // format ; rightmost item
				// partition range
			   int partition = popPartitionIt(left, right, pivot);
			   popQuickSort(left, partition-1);   // sort left side
			   popQuickSort(partition+1, right);  // sort right side
		   }
   }
   
   
   /** for quicksorting
    * 
    * @param dex1
    * @param dex2
    */
   public void swap(int dex1, int dex2) {
		String temp = goCatArray[dex1];      	// A into temp
		goCatArray[dex1] = goCatArray[dex2];   // B into A
		goCatArray[dex2] = temp;             			// temp into B
	}  // end swap   


	/** for external calling from tableapplet - turn on table selected members on viewer
	 * 
	 * @param tableSelect
	 */
	public void setTableSelectedNodes(ArrayList tableSelect){
		//1. go thru tableSelect gene names to turn display flag on
		
		// default all members to false first
		for (int k = 0; k < panel.getNodeCount(); k++) {
			panel.Nodes[k].on = false;
		}
		
		if (tableSelect == null) {
			return;
		}
		
		LOOP1:
		for (int j = 0; j < tableSelect.size(); j++) {
			String current = (String) tableSelect.get(j);
			
			// go thru all members for match
			for (int i = 0; i < panel.getNodeCount(); i++) {
				if (current.equals(panel.Nodes[i].lbl))	{
					panel.Nodes[i].on = true;
					continue LOOP1;
				} 
			}
		}	
	}
    
	/**	MENU FUNCTIONALITY - get members of a given GO class
	 * 
	 * @param gechoiced
	 */
    public void showSelectedNodes(String gechoiced) {
		  int[] indexOn = new int[1000]; // for storing a subset of member indices which need to be turned on
		  int ct  = 0;
		  boolean thisFlag=false; // if members need to be turned on - flag
   
		  for (int i = 0; i < panel.nGOcats; i++) { //all bv #s
			  for (int k = 0; k < panel.GOcats[i].goList.length; k++){ //all long label functions
		   
					if (panel.GOcats[i].goList[k] == null) { // break out of inner loop and move to these bv# if you hit a null
						break;
					}
		
				   	if (panel.GOcats[i].goList[k].equals(gechoiced)) { 	// if selected menu choice equals current long label
					   //System.out.println("i: " + i + "  k: " + k);
				
					   	for (int j = 0; j < panel.getNodeCount(); j++) {  // go thru all member nodes
							   String nodeName = panel.Nodes[j].lbl;
							   String bvNumber = panel.GOcats[i].bioverseId; 
	
							   if (panel.Nodes[j].funkflag[i] == true) {  // store which member indices need to be turned on
								   indexOn[ct] = j;
								   ct++;
								   thisFlag = true;
							
							   } else {
								   panel.Nodes[j].on = false;
								   //System.out.println("FALSE    node: " + nodeName + "  bv: " + bvNumber);
							   }
					   	} // for
				   	} // if
			  }//for
		  }//for
       
		   // turn on members with indices which need to be turned on    
		   if (thisFlag) {
			   for (int i = 0; i < ct; i++) {
				   int index = indexOn[i];
				   panel.Nodes[index].on = true;
			   }
		   }
    
		   // if the user picks ALL 
		   if(gechoiced.equals("ALL categories")) {
			   for (int ri = 0 ; ri < panel.getNodeCount() ;ri++) {
				   panel.Nodes[ri].on=true;
			   }    
		   }  
    }
    
    
    /**applet
     * 
     */
    public void start() {
		panel.start();	
    }
    
    /** applet
     * 
     */
    public void stop() {
		panel.stop();
    }
   
}


/** internal class to keep track of running instances?
 * 
 */
class Running {
	public int count;
	public int maxcount;
}




