/* Author: Ram Samudrala (me@ram.org)
 * September 27, 1997.
 * modified Hong Hung Sept 2006
 */

#ifndef __DEFINES__
#define __DEFINES__
#define MAX_INSTANCE_SIZE 16515072
#define MAX_STREAM_SIZE   66060288
#define MAX_STREAM_WIDTH 2016;
#define UMAX 4294967295
#define IMAX 2147483647

/******************************************************************
 * CHANGEABLE CONSTANTS: Defines you probably should change to suit
 * your preferences.
 */
/******************************************************************/
/* Filenames */


#ifndef DEFAULT_PHI_PSI_DISCRETE_STATE_MODEL
#define DEFAULT_PHI_PSI_DISCRETE_STATE_MODEL "default"
#endif

/******************************************************************/
/* Various constants. */

/* Initial KT used in src/common/boltzmann.c */
#ifndef INITIAL_KT
#define INITIAL_KT 0.05
#endif

/* Maximum number of possible values for a given chi/phi/psi angle in
 * the chi/phi/psi allowed angles library. 
 */
#ifndef MAX_ACCEPTED_CHI_VALUES
#define MAX_ACCEPTED_CHI_VALUES 10
#endif

#ifndef MAX_ACCEPTED_PHI_VALUES
#define MAX_ACCEPTED_PHI_VALUES 15
#endif

#ifndef MAX_ACCEPTED_PSI_VALUES
#define MAX_ACCEPTED_PSI_VALUES 15
#endif

#define NUM_NOE_BINS 20

/* This could be the same as MAX_SIDECHAINS, though this is the limit
 * set by MAX_ACCEPTED_CHI_VALUES to the power of MAX_NUM_CHIS.
 * MAX_SIDECHAINS can be a lot less than this value.
 */
#define MAX_ALTERNATE_ATOM_CONFORMATIONS 200

/* Maximum number of cliques to be output. */
#define MAX_CLIQUES 100

/* Maximum number of distance constraints. */
#define MAX_CONSTRAINTS 10

/* Maximum number of main chains to be input/output to the CF or MCGEN algorithms. */
#ifndef MAX_MAINCHAINS
#define MAX_MAINCHAINS 100
#endif

/* In general, the maximum number of nodes we can have is (if we allow
 * for one residue/node) is MAX_MAINCHAINS * MAX_SIDECHAINS.  If we
 * have two residues/per node, then the maximum number of nodes we can
 * have is MAX_MAINCHAINS * (MAX_SIDECHAINS^2).  But note that this is
 * all co-dependent on MAX_ALTERNATE_ATOM_CONFORMATIONS.  That is, we
 * assume that all conformations will be generated by my scgen
 * program.  There's no reason why more sidechains and more mainchains
 * from other sources can't be given as input to the graph-making
 * program. 
 */
#ifndef MAX_NODES
#define MAX_NODES 1000
#endif

/* Maximum number of residues for a chain. Check
 * RESIDUE_NUMBER_LOCATION if this increases to more than 999 or 9999. 
 */
#ifndef MAX_RESIDUES
#define MAX_RESIDUES 500
#endif

/* Maximum and minimum default score values to use for initialisation
 * purposes.
 */
#define MAX_SCORE 9999999.99
#define MIN_SCORE -99999999.99

/* Maximum number of side chains to be input per chain to the CF
 * algorithm. 
 */
#define MAX_SIDECHAINS 10

#define MAX_SECTORS 300
#define NUM_SS_TRIPLETS 18
#define SS_PROBABILITY_SCALE 100

/******************************************************************/
/* Cutoffs. */

/* Clash cutoff. */
#define CLASH_CUTOFF 2.0

/* The distance between two C alphas before it can be
 * evaluated for pairwise side chain score.
 */
#define DOUBLE_SIDECHAIN_CA_CUTOFF 8.0

#define LOCAL_MC_CUTOFF 4
#define NONLOCAL_MC_CUTOFF MAX_RESIDUES
#define MAX_DISTANCE_CUTOFF 20.0 /* 20.0 is the default. */
#define MIN_DISTANCE_CUTOFF 3.0

/* Van der Waals cutoff. Used to determine cutoff where score is
 * significant. 
 */
#ifndef VDW_CUTOFF
#define VDW_CUTOFF 8.0
#endif

/******************************************************************/
/* Flags */

/* Check for clashes as per CLASH_CUTOFF. */
/* #define CLASH_CHECK */

/* This is length of the distance bin for the scoring function. */
#define CUTOFF_ONE
/* #define CUTOFF_POINT_FIVE */
/* #define CUTOFF_POINT_THREE */

/* Define if you want mc_local() to calculate the entire non-local
 * score. 
 */
/* #define MC_NONLOCAL_IS_MC_LOCAL */

/* One-four exclusions. */
/* #define ONE_FOUR_EXCLUSION */

/* Type of probability discriminatory function (PDF). Define one of 
 * RAPDF - Residue-specific all-atom PDF.
 * RVPDF - Residue-specific virtual-atom PDF.
 * NVPDF - Non-residue-specific virtual-atom PDF.
 * Make sure a PDF isn't already defined in a Makefile first, to
 * avoid multiply defined errors.
 */
#ifndef RAPDF
#ifndef RVPDF
#ifndef NVPDF
#define RAPDF 
#endif /* NVPDF */
#endif /* RVPDF */
#endif /* RAPDF */

/* Type of score. Define one of:
 * REGULAR_SCORE - Vanilla score.
 * INTERPOLATED_SCORE - Do linear interpolated between points.
 * ELECTROSTATIC_SCORE - Include only N, C, CA, O interactions.
 */
/* #define INTERPOLATED_SCORE */
#define REGULAR_SCORE

/* In side chain generation, use only SC -> MC interactions for the
 * war score. 
 */
#define SC_TO_MC_ONLY

/* Check to see if you want to skip the main chain mc_local_score (in
 * mc_scores.c) to avoid double counting. 
 */
#define SKIP_MAINCHAIN_MC_LOCAL

/* Verbose output.  If turned out, only the required output will be
 * made.  I highly recommend against turning this off.
 */
#define VERBOSE
#define MAX_TOR_CONFQ_SCORE 999999999.0
#define MIN_TOR_CONFQ_SCORE -999999999.0
#define MAX_TOR_CONF_QUEUE_SIZE 100
/******************************************************************
 * NOT-SO-CHANGEABLE CONSTANTS: Defines you normally shouldn't mess
 * around with unless you know what you're doing.  */
/******************************************************************/
/* Lengths. */

#define ATOM_NAME_LENGTH 5
#define FILENAME_LENGTH 1000
#define LINE_LENGTH 1000
#define MOLECULE_NAME_LENGTH 10
#define POTENTIAL_LINE_LENGTH 3000
#define STRING_LENGTH 1000
#define RESIDUE_NAME_LENGTH 4  /* 3 + NULL */
#define RESIDUE_NUMBER_LENGTH 5  /* 0000...9999 + NULL */

/******************************************************************/
/* Strings */

#define ALIGNMENT_LIST_FILENAME_EXTENSION ".alignments"
#define DSSP_FILENAME_EXTENSION ".dssp"
#define PDB_FILENAME_EXTENSION ".pdb"
#define SS_FILENAME_EXTENSION DSSP_FILENAME_EXTENSION
#define CONFORMATION_FILENAME_EXTENSION PDB_FILENAME_EXTENSION
#define VERSION "RAMP v0.3 by Ram Samudrala (ram@compbio.washington.edu)"

/******************************************************************/
/* Various constants */

/* Some numbers for the torsion angles. */
#define CHI_1 0
#define CHI_2 1
#define CHI_3 2
#define CHI_4 3
#define PHI 4
#define PSI 5

/* Column locations in various files. */
#define CHI_VALUES_LOCATION 13
#define PHI_PSI_VALUES_LOCATION 13

/* Default phi/psi values (0-360). */
#define DEFAULT_HELIX_PHI_ANGLE 303.0
#define DEFAULT_HELIX_PSI_ANGLE 313.0
#define DEFAULT_SHEET_PHI_ANGLE 231.0
#define DEFAULT_SHEET_PSI_ANGLE 124.0

/* Uncomment this if you want to include the score of a node in the
 * final score of a clique---this may result in a double-counted
 * score.
 */
/* #define DONT_IGNORE_NODE_SCORE  */

/* Maximum number of atoms per residue. */
#define MAX_ATOMS_PER_RESIDUE 15

/* Number of amino acid types. */
#define NUM_AMINO_ACIDS 20

/* Number of atoms you say are part of the main chain. */
#define NUM_MAINCHAIN_ATOMS 5

/* Maximum number of chi angles. */
#define MAX_NUM_CHIS 4

/* Various secondary structure definitions. */
#define SS_HELIX 0
#define SS_SHEET 1
#define SS_FIXED 9
#define SS_HELIX_TYPE 'H'
#define SS_SHEET_TYPE 'E'
#define SS_FIXED_TYPE 'F'
#define SS_OTHER_TYPE '_'

/******************************************************************/

/* Count to initialise raw counts to, mainly to avoid division by zero. */
#define INITIAL_RAW_COUNT 1

#define INITIAL_PHI_ANGLE -999.9
#define INITIAL_PSI_ANGLE -999.9
#define INITIAL_CHI_ANGLE -999.9

/******************************************************************/
/* Actions to take based on defines above, or in Makefiles. */

#ifdef RAPDF
#define NUM_GROUPS 168 /* This should be the number of atomic groups + 1. */
#endif

#ifdef RVPDF
#define NUM_GROUPS 106  /* 22 for NVPDF or 106 for RVPDF. */
#endif

#ifdef NVPDF
#define NUM_GROUPS 22  /* 22 for NVPDF or 106 for RVPDF. */
#endif

#define MAX_ATOMS (MAX_RESIDUES * MAX_ATOMS_PER_RESIDUE)
#define MAX_TORSIONS (MAX_RESIDUES * 2 * MAX_NUM_CHIS)

/* Maximum number of torsions (per residue). */
#define MAX_NUM_TORSIONS (2 + MAX_NUM_CHIS)

#ifdef MC_NONLOCAL_IS_MC_LOCAL
#undef LOCAL_MC_CUTOFF
#define LOCAL_MC_CUTOFF NONLOCAL_MC_CUTOFF
#endif

#ifdef CUTOFF_ONE
#define NUM_DISTANCES 18
#define DISTANCE_BIN_SIZE 1.0
#endif

#ifdef CUTOFF_POINT_FIVE
#define NUM_DISTANCES 35
#define DISTANCE_BIN_SIZE 0.5
#endif

#ifdef CUTOFF_POINT_THREE
#define NUM_DISTANCES 32
#define DISTANCE_BIN_SIZE 0.3
#endif

#ifdef DOUBLE_NODES
#define NUM_RESIDUES_PER_NODE 2
#else
#define NUM_RESIDUES_PER_NODE 1
#endif

/******************************************************************/
/* Geometric constants. */

#define N_CA_DISTANCE  1.47
#define CA_C_DISTANCE  1.53
#define C_N_DISTANCE   1.32
#define C_O_DISTANCE   1.24
#define CA_CB_DISTANCE 1.53
#define N_CD_DISTANCE  1.47

/******************************************************************/
/* Mathematical constants. */

#define TO_DEGREES 180.0/M_PI
#define TO_RADIANS M_PI/180.0

/******************************************************************/
/*potential constants*/

#define HCF_SCORE_STP 3
#define RAPDF_SCORE_STP 0.3
#define BAD_CONTACTS_SCORE_STP 75.0
#define RAPDF_SCORE_STQ 0.33
#define HCF_SCORE_STQ 33
#define BAD_CONTACTS_SCORE_STQ 50.0
#define RAPDF_SCORE_STM .66
#define HCF_SCORE_STM 22
#define BAD_CONTACTS_SCORE_STM 30.0

#define RAPDF_SCORE_M 1.0
#define HCF_SCORE_M 50.0
#define BAD_CONTACTS_SCORE_M 10.0
#define RAPDF_SCORE_MC .5
#define HCF_SCORE_MC 1.0
#define BAD_CONTACTS_SCORE_MC 75.0
#define RAPDF_SCORE_QC 0.5
#define HCF_SCORE_QC 11.0
#define BAD_CONTACTS_SCORE_QC 75.0
#define RAPDF_SCORE_Q 0.5
#define HCF_SCORE_Q 50.0
#define BAD_CONTACTS_SCORE_Q 15
#define BAD_CONTACTS_SCORE_SM 4.5
#define RAPDF_SCORE_SM 1.0
#define HCF_SCORE_SM 12.0
#define BAD_CONTACTS_SCORE_SQ 6.7
#define RAPDF_SCORE_SQ 0.5
#define HCF_SCORE_SQ 12.0
#define STRAND_BRIDGE_BONUS -500
#define UNPAIRED_STRAND_PENALTY 12
/******************************************************************/

#endif /* __DEFINES__ */
