#define __CL_ENABLE_EXCEPTIONS
#include <CL/cl.hpp>
#include <omp.h>
#include "lite.h"
#include "error_handlers.h"
#include <iostream>

using namespace std;

float tmscore_cpu(int nat,float *coords1,float *coords2, float bR[3][3], float bt[3]);
int read_list_of_decoys(int *nat, char *filename,float **coords,char **names, int **name_offsets);
int find_tmscore_matrix(int cpu_flag,int nt, int nwg_per_cu,char *source,int nats,int nstructs, float *coords, float **matrix);

int main(int argc, char *argv[])
{
 int nats=0,nstructs,i,j,pdb_size,*name_offsets=0,m=0,pdb4_size,nat4,*res_nums,*names_offsets,nt=0,cpu_flag=0,nwg_per_cu=0;;  
 char input_filename[FILENAME_LENGTH],source_filename[FILENAME_LENGTH],output_filename[FILENAME_LENGTH],*names=0;
 float *coords=0,*scores=0,**matrix=0;
 FILE *output_fp;
 strcpy(input_filename, STDIN_FILENAME);
 strcpy(output_filename, STDOUT_FILENAME);
 
 i=1;
 while(i<argc)
 {
  if(argv[i][0] == '-' && argv[i][1] != '\0')
  {
   char option=argv[i][1];
   switch(option)
   {
    case 'c': cpu_flag=1;break;
    case 'i' :
    {
     //input file
     i++;
     strcpy(input_filename, argv[i]);
    }
    break;
    case 'o' :
    {
     //output file
     i++;
     strcpy(output_filename, argv[i]);
    }
    break;
    default : 
    {
     fprintf(stderr,"unrecognized option %s \n",argv[i]);
     exit(FALSE);
    }
   }
   i++;
  }
  else
  {
   fprintf(stderr,"unrecognized option %s \n",argv[i]);
   exit(FALSE);
  }
 }

 //read in the list of structures
 open_file(&output_fp, output_filename, "w", 0);
 nstructs=read_list_of_decoys(&nats,input_filename,&coords, &names,&names_offsets);
 //set sizes
 pdb_size=nats*3;
 nat4=(nats%4)? nats/4+1: nats/4; 
 pdb4_size=nat4*3;
 
 float R[3][3],t[3];
 if(!(matrix=(float**)malloc(nstructs*sizeof(float*))))exit(FALSE);
 
 for(int j=0;j<nstructs;j++)
  if(!(matrix[j]=(float*)malloc(nstructs*sizeof(float))))exit(FALSE);
 
if(cpu_flag)
{
 double start_rmsd= omp_get_wtime();  
 for (int i=0;i<nstructs-1;i++)
  for (int j=i+1;j<nstructs;j++)
   matrix[i][j]=tmscore_cpu(nats,&(coords[i*pdb_size]),&(coords[j*pdb_size]),R,t);
 double end=omp_get_wtime();  
 fprintf(stderr, "%8.3f seconds elapsed for %d TM-scores at %8.3f ms per TM-score\n",end-start_rmsd,nstructs*(nstructs-1)/2,(float)((end-start_rmsd)*1000)/(float)(nstructs*(nstructs-1)/2));
}
 else find_tmscore_matrix(0,64,0,"tmscore.cl",nats,nstructs,coords,matrix);

 for (int i=0;i<nstructs-1;i++)
  for (int j=i+1;j<nstructs;j++)
   fprintf(output_fp,"%s %s %8.3f\n",&(names[names_offsets[i]]),&(names[names_offsets[j]]),matrix[i][j]);

 for(int i=0;i<nstructs;i++)
  if(matrix[i])free(matrix[i]);
 if(matrix) free(matrix);
 close_file(&output_fp, output_filename,"main");
 return TRUE;
}

