#!/usr/bin/perl
my($nthreads,$thread)=@ARGV;
$base_dir="/media/storage/wcgrid_structures/spicker_files";
$bin_dir="/media/data/home/lhhung/bin";
my(@bin_files)=split(' ',`ls /media/storage/complete_zhang_matrices/* | grep bin | grep rmsd`);
foreach my $b (0..$#bin_files){
 if(!$nthreads || ($b % $nthreads == $thread)){
  my $bin_file=$bin_files[$b];
  
  my $name;
  if($bin_file =~/s\/([0-9\_a-zA-Z]+)\.rmsd/){
   $name=$1;
  }
  unless (-e "$base_dir/$name"){mkdir("$base_dir/$name")}
  chdir("$base_dir/$name");
  my $list_file=substr($bin_file,0,-3)."list";
  print stderr "working  on $list_file\n";
  my @seq;
  my $nca=get_sequence($list_file,\@seq);
  open (OUT,">seq.dat") || die;
  foreach my $i(1..$nca){
   printf OUT "%5d %5s\n",$i,$seq[$i];
  }
  close OUT;
  open (OUT,">rmsinp") || die;
  printf OUT "1 %d\n%d",$nca,$nca;
  close OUT;
  open (OUT,">tra.in") || die;
  printf OUT "1 -1 -1\n%s",substr($list_file,0,-4)."tra2";
  close OUT; 
  system("../spicker");
 }
 #convert_list_to_spicker($list_file);
}
#create spicker traj file


sub convert_list_to_spicker{
 my ($file)=@_;
 my ($line,@names);
 open (FIL,$file) || die "can't open $file\n";
 while (defined($line=<FIL>)){
  my ($temp)=split(' ',$line);
  if ($temp =~ /pdb/){ push(@names,$temp)}
 }
 close(FIL);
 my $out_file=substr($file,0,-4)."tra";
 open(OUT,">$out_file") || die;
 foreach my $i (0..$#names){
  my $name=$names[$i];
  my @lines=get_CAs($name,$i+1);
  foreach my $line(@lines){
   print OUT "$line\n";
  }
 }
 close(OUT);
}
sub get_sequence{
 my ($list,$seq)=@_;
 my (@res_ids);
 my ($line,$pdb);
 open (FIL,$list) || die "can't open $list\n";
 if (defined($line=<FIL>)){
  ($pdb)=split(' ',$line);
 }
 close(FIL);
 #counts for CAs and any number of dupes
 my $nca=0;
 open (FIL,$pdb) || die "can't open $pdb\n";
 my $e=0;
 if(defined($line=<FIL>)){
  if($line=~/\=([\-0-9\.]+)/){
   $e=$1;
  }
 }
 while (defined($line=<FIL>)){
  if (substr($line,0,4) eq "ATOM" && substr($line,13,2) eq "CA"){ 
   my $seqnum=sprintf "%d",substr($line,22,4);
   $res_ids[$seqnum]=substr($line,17,3);
   $nca++;
  }
 }
 close(FIL);
 @{$seq}=@res_ids;
 return($nca);
}


sub get_CAs{
 my ($file,$n)=@_;
 #counts for CAs and any number of dupes
 my ($line);
 my @out;
 my $nca=0;
 open (FIL,$file) || die "can't open $file\n";
 my $e=0;
 if(defined($line=<FIL>)){
  if($line=~/\=([\-0-9\.]+)/){
   $e=$1;
  }
 }
 while (defined($line=<FIL>)){
  if (substr($line,0,4) eq "ATOM" && substr($line,13,2) eq "CA"){
   $nca++;
   push(@out,substr($line,30,24));
  }
 }
 close(FIL);
 unshift(@out,"$nca $e $n $n");
 return(@out);
}
sub count_atoms{
 my ($file)=@_;
 #counts for CAs and any number of dupes
 my ($line,$nca,%CA_seen,%coords_seen,$ndupes);
 open (FIL,$file) || die "can't open $file\n";
 while (defined($line=<FIL>)){
  if (substr($line,0,4) eq "ATOM"){
   $nca++;
   my $resnumc=substr($line,22,6).substr($line,12,4);
   my $coords_str=substr($line,30,24);
   if($CA_seen{$resnumc}++ || $coords_seen{$coords_str}++ ){
    $ndupes++;
   }
  }
 }
 close(FIL);
 return($nca,$ndupes);
}

